 /*
   *  Object %name    : FVOS.c
   *  State           :  %state%
   *  Creation date   :  Wed Nov 17 17:39:24 2004
   *  Last modified   :  %modify_time%
   */
  /** @file
   *  \brief Secure Boot implemtation of hash queues
   *
   *  \version 
   *  \author yevgenys
   *  \remarks Copyright (C) 2004 by Discretix Technologies Ltd.
   *           All Rights reserved
   */
#include "DX_VOS_Mem.h"

#include "FVOS_Types.h"
#include "FVOS_API.h"
#include "FVOS_Config.h"
#include "FVOS_HwDefs.h"
#include "gen.h"
#include "FVOS_Error.h"

#ifdef DX_CHECK_INTERRUPTS_ON_BOARD

void DX_CC_BOOT_HashIrqHandler()
{
  /* current flow id */
  DxUint32_t  flowId;
  
  /* irr val */
  DxUint32_t  irrVal;
  
  /* error */
  DxError_t   error;
  
  /* next queue to process */
  DxUint32_t NextQueueEntryToProcess;
  
  /* loop variable */
  int i;
  
  /*---------------------
    CODE
  ----------------------*/
  
  DX_GEN_ReadRegister(0xc0000A00 , irrVal);
  
  NextQueueEntryToProcess = 0;
  
  i = NextQueueEntryToProcess + 5;
}


void DX_CC_BOOT_InstallIRQHandler(DxUint32_t* handlerAddr)
{
  unsigned vec;
  
  DxUint32_t* addr = (DxUint32_t*)0x18; 
  
  vec = (DxUint32_t)handlerAddr - (DxUint32_t)addr - 0x8;
  vec = vec >> 2;
  if ((vec & 0xFF000000) != 0)
  {
    /* diagnose the fault */
    return;
  }
  vec = 0xEA000000 | vec;
  *addr = vec;
}
#endif

/**
 * @brief     This is porting function which is called during initialization fo the FVOS by the FVOS_Config function
 *            It must be impelemented ( if needed), for a specific RTOS. It may include interrupts handler initialization
 *
 * @return     DxError_t_t:  
 *                        
 */
void FVOS_RTOS_Config()
{
#ifdef DX_CHECK_INTERRUPTS_ON_BOARD
  int tmp;
  
  DX_CC_BOOT_InstallIRQHandler((DxUint32_t*)DX_CC_BOOT_HashIrqHandler);
  
  DX_GEN_WriteRegister( 0x14000004 , 
    	                           0x0);
  	                           
    DX_GEN_WriteRegister( 0x14000008 , 
    	                           0x0);
  	                           
    DX_GEN_WriteRegister( 0x1400000c , 
    	                           0xFFFFFFFF);
  	                           
    DX_GEN_WriteRegister( 0x14000008 , 
    	                           0xF << 9);
    __asm
    {
        MRS tmp, CPSR
        BIC tmp, tmp, #0x80
        MSR CPSR_c, tmp
        MRC p15, 0, r0, c1, c0, 0       //; read CP15 register 1 into r0
        ORR     r0, r0, #(0x0 <<12)     //    ; enable I Cache
      	ORR     r0, r0, #(0x0 <<2)     //     ; enable D Cache
      	MCR     p15, 0, r0, c1, c0, 0   //    ; write cp15 register 1  


    }
    
#endif
    
  return;
}


/**
 * @brief     This is porting function which suspends execution till receiving notification from SEP.
 *            function can work in 2 modes: blocking (wait indefinitly), or with timeout, in which case an FVOS_TIMEOUT_ERR error
 *            will be returned 
 *
 * @param[in] Timeout - timeout for polling
 * @return     DxError_t_t:  
 *                        
 */
FVOS_Error_t FVOS_RTOS_WaitSepNotification(DxUint32_t timeout)
{
  return FVOS_OK;
}

/**
 * @brief     This is porting function which is called before any access to SEP memory or HW is performed
 *            It must either lock the access, or block until it can lock. Can be implemented by Mutex or Semaphore
 *
 * @return   
 *                        
 */
void FVOS_RTOS_LockSep(void)
{
  return;
}

/**
 * @brief     This is porting function which is called to unlock the access to SEP memory or hardware
 *
 * @return   
 *                        
 */
void FVOS_RTOS_UnlockSep(void)
{
  return;
}